// $Id: CAlphaColour.cpp,v 1.6 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CAlphaColour.hpp"
#include <Basics/CString.hpp>
using Exponent::Basics::CString;
using Exponent::GUI::Basics::CAlphaColour;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CAlphaColour, CColour);

//	===========================================================================
const CAlphaColour CAlphaColour::CALPHACOLOUR_BLACK = CAlphaColour(0, 0, 0);

//	===========================================================================	
const CAlphaColour CAlphaColour::CALPHACOLOUR_WHITE = CAlphaColour(255,	255, 255);

//	===========================================================================
const CAlphaColour CAlphaColour::CALPHACOLOUR_RED = CAlphaColour(243, 32, 32);

//	===========================================================================
const CAlphaColour CAlphaColour::CALPHACOLOUR_GREEN = CAlphaColour(102, 200, 85);

//	===========================================================================
const CAlphaColour CAlphaColour::CALPHACOLOUR_BLUE = CAlphaColour(85, 86, 200);

//	===========================================================================
const CAlphaColour CAlphaColour::CALPHACOLOUR_YELLOW = CAlphaColour(219, 230, 49);

//	===========================================================================
const CAlphaColour CAlphaColour::CALPHACOLOUR_ORANGE = CAlphaColour(239, 149, 41);

//	===========================================================================
const CAlphaColour CAlphaColour::CALPHACOLOUR_TURQUOISE = CAlphaColour(116,	184, 188);

//	===========================================================================
const CAlphaColour CAlphaColour::CALPHACOLOUR_PURPLE = CAlphaColour(153, 116, 188);

//	===========================================================================
const CAlphaColour CAlphaColour::CALPHACOLOUR_PINK = CAlphaColour(226, 74, 160);

//	===========================================================================
const CAlphaColour CAlphaColour::CALPHACOLOUR_LIGHT_GREY = CAlphaColour(208, 208, 208);

//	===========================================================================
const CAlphaColour CAlphaColour::CALPHACOLOUR_DARK_GREY = CAlphaColour(147, 147, 147);

//	===========================================================================
CAlphaColour::CAlphaColour(const unsigned long red, const unsigned long green, const unsigned long blue, const unsigned long alpha) : CColour(red, green, blue), m_alpha(255)
{
	EXPONENT_CLASS_CONSTRUCTION(CAlphaColour);
	this->setAlpha(alpha);
}

//	===========================================================================
CAlphaColour::CAlphaColour() : CColour(255, 255, 255), m_alpha(255)
{
	EXPONENT_CLASS_CONSTRUCTION(CAlphaColour);
	this->setAlpha(255);
}

//	===========================================================================
CAlphaColour::CAlphaColour(const CAlphaColour &colour) : CColour(colour.getRed(), colour.getGreen(), colour.getBlue()), m_alpha(255)
{
	EXPONENT_CLASS_CONSTRUCTION(CAlphaColour);
	this->setAlpha(colour.getAlpha());
}

//	===========================================================================
CAlphaColour::~CAlphaColour()
{
	EXPONENT_CLASS_DESTRUCTION(CAlphaColour);
}

//	===========================================================================
CAlphaColour &CAlphaColour::operator = (const CAlphaColour &colour)
{
	this->setColour(colour.getRed(), colour.getGreen(), colour.getBlue(), colour.getAlpha());
	return (*this);
}

//	===========================================================================
CAlphaColour &CAlphaColour::operator = (const CColour &colour)
{
	this->setColour(colour.getRed(), colour.getGreen(), colour.getBlue(), 255);
	return (*this);
}

//	===========================================================================
bool CAlphaColour::operator == (const CAlphaColour &colour) const
{
	return ((m_red == colour.getRed()) && (m_green == colour.getGreen()) && (m_blue == colour.getBlue()) && (m_alpha == colour.getAlpha()));
}

//	===========================================================================
void CAlphaColour::setColour(const unsigned long red, const unsigned long green, const unsigned long blue, const unsigned long alpha)
{
	CColour::setColour(red, green, blue);
	this->setAlpha(alpha);
}

//	===========================================================================
CColour *CAlphaColour::getAsColour() const
{
	return new CColour(m_red, m_green, m_blue);
}

//	===========================================================================
void CAlphaColour::getAsColour(CColour &colour) const
{
	colour.setColour(m_red, m_green, m_blue);
}

//	===========================================================================
void CAlphaColour::getObjectDescription(char *string, const long size) const
{
	CString myString;
	myString.setStringWithFormat("[%li,%li,%li,%li]", m_red, m_green, m_blue, m_alpha);
	myString.getString(string, size);
}

//	===========================================================================
void CAlphaColour::lightenColour()
{
	CAlphaColour destination;	
	CAlphaColour::alphaBlend(destination, CColour::CCOLOUR_WHITE, *this, 127);
	*this = destination;	
}

//	===========================================================================
void CAlphaColour::darkenColour()
{
	CAlphaColour destination;	
	CAlphaColour::alphaBlend(destination, CColour::CCOLOUR_BLACK, *this, 127);
	*this = destination;									
}